/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.utils;

import android.text.TextUtils;
import android.util.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LogUtils {
    private static boolean IS_SHOW_LOG = true;
    private static final String DEFAULT_MESSAGE = "execute";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int JSON_INDENT = 4;
    private static final int V = 1;
    private static final int D = 2;
    private static final int I = 3;
    private static final int W = 4;
    private static final int E = 5;
    private static final int A = 6;
    private static final int JSON = 7;

    public static void init(boolean isShowLog) {
        IS_SHOW_LOG = isShowLog;
    }

    public static void v() {
        LogUtils.printLog(1, null, DEFAULT_MESSAGE);
    }

    public static void v(Object msg) {
        LogUtils.printLog(1, null, msg);
    }

    public static void v(String tag, String msg) {
        LogUtils.printLog(1, tag, msg);
    }

    public static void d() {
        LogUtils.printLog(2, null, DEFAULT_MESSAGE);
    }

    public static void d(Object msg) {
        LogUtils.printLog(2, null, msg);
    }

    public static void d(String tag, Object msg) {
        LogUtils.printLog(2, tag, msg);
    }

    public static void i() {
        LogUtils.printLog(3, null, DEFAULT_MESSAGE);
    }

    public static void i(Object msg) {
        LogUtils.printLog(3, null, msg);
    }

    public static void i(String tag, Object msg) {
        LogUtils.printLog(3, tag, msg);
    }

    public static void w() {
        LogUtils.printLog(4, null, DEFAULT_MESSAGE);
    }

    public static void w(Object msg) {
        LogUtils.printLog(4, null, msg);
    }

    public static void w(String tag, Object msg) {
        LogUtils.printLog(4, tag, msg);
    }

    public static void e() {
        LogUtils.printLog(5, null, DEFAULT_MESSAGE);
    }

    public static void e(Object msg) {
        LogUtils.printLog(5, null, msg);
    }

    public static void e(String tag, Object msg) {
        LogUtils.printLog(5, tag, msg);
    }

    public static void a() {
        LogUtils.printLog(6, null, DEFAULT_MESSAGE);
    }

    public static void a(Object msg) {
        LogUtils.printLog(6, null, msg);
    }

    public static void a(String tag, Object msg) {
        LogUtils.printLog(6, tag, msg);
    }

    public static void json(String jsonFormat) {
        LogUtils.printLog(7, null, jsonFormat);
    }

    public static void json(String tag, String jsonFormat) {
        LogUtils.printLog(7, tag, jsonFormat);
    }

    private static void printLog(int type, String tagStr, Object objectMsg) {
        if (!IS_SHOW_LOG) {
            return;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int index = 4;
        String className = stackTrace[index].getFileName();
        String methodName = stackTrace[index].getMethodName();
        int lineNumber = stackTrace[index].getLineNumber();
        String tag = tagStr == null ? className : tagStr;
        methodName = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ (").append(className).append(":").append(lineNumber).append(")#").append(methodName).append(" ] ");
        String msg = objectMsg == null ? "Log with null Object" : objectMsg.toString();
        if (msg != null && type != 7) {
            stringBuilder.append(msg);
        }
        String logStr = stringBuilder.toString();
        switch (type) {
            case 1: {
                Log.v((String)tag, (String)logStr);
                break;
            }
            case 2: {
                Log.d((String)tag, (String)logStr);
                break;
            }
            case 3: {
                Log.i((String)tag, (String)logStr);
                break;
            }
            case 4: {
                Log.w((String)tag, (String)logStr);
                break;
            }
            case 5: {
                Log.e((String)tag, (String)logStr);
                break;
            }
            case 6: {
                Log.wtf((String)tag, (String)logStr);
                break;
            }
            case 7: {
                if (TextUtils.isEmpty((CharSequence)msg)) {
                    Log.d((String)tag, (String)"Empty or Null json content");
                    return;
                }
                String message = null;
                try {
                    if (msg.startsWith("{")) {
                        JSONObject jsonObject = new JSONObject(msg);
                        message = jsonObject.toString(4);
                    } else if (msg.startsWith("[")) {
                        JSONArray jsonArray = new JSONArray(msg);
                        message = jsonArray.toString(4);
                    }
                }
                catch (JSONException e) {
                    LogUtils.e(tag, e.getCause().getMessage() + "\n" + msg);
                    return;
                }
                LogUtils.printLine(tag, true);
                message = logStr + LINE_SEPARATOR + message;
                String[] lines = message.split(LINE_SEPARATOR);
                StringBuilder jsonContent = new StringBuilder();
                for (String line : lines) {
                    jsonContent.append("\u2551 ").append(line).append(LINE_SEPARATOR);
                }
                if (jsonContent.toString().length() > 3200) {
                    Log.w((String)tag, (String)("jsonContent.length = " + jsonContent.toString().length()));
                    int chunkCount = jsonContent.toString().length() / 3200;
                    for (int i = 0; i <= chunkCount; ++i) {
                        int max = 3200 * (i + 1);
                        if (max >= jsonContent.toString().length()) {
                            Log.w((String)tag, (String)jsonContent.toString().substring(3200 * i));
                            continue;
                        }
                        Log.w((String)tag, (String)jsonContent.toString().substring(3200 * i, max));
                    }
                } else {
                    Log.w((String)tag, (String)jsonContent.toString());
                }
                LogUtils.printLine(tag, false);
            }
        }
    }

    private static void printLine(String tag, boolean isTop) {
        if (isTop) {
            Log.w((String)tag, (String)"\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        } else {
            Log.w((String)tag, (String)"\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        }
    }
}

